import { BookOpen, Mail, Phone, MapPin, Clock } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <BookOpen size={22} strokeWidth={1.5} />
              <h2 className="footer-logo-text">Академия ЕГЭ</h2>
            </div>
            <p className="footer-description">
              Классическая подготовка к ЕГЭ с глубоким изучением предметов. 
              Традиционные методы обучения и индивидуальный подход к каждому ученику.
            </p>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Навигация</h3>
            <ul className="footer-links">
              <li><a href="/">Мои курсы</a></li>
              <li><a href="/enroll">Записаться</a></li>
              <li><a href="#">О нас</a></li>
              <li><a href="#">Отзывы</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={14} strokeWidth={1.5} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={14} strokeWidth={1.5} />
                <a href="mailto:info@academy-ege.ru">info@academy-ege.ru</a>
              </li>
              <li>
                <MapPin size={14} strokeWidth={1.5} />
                <span>Санкт-Петербург, ул. Академическая, 12</span>
              </li>
              <li>
                <Clock size={14} strokeWidth={1.5} />
                <span>Пн-Сб: 10:00 - 20:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 Академия ЕГЭ. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

